//Experiment-12
// windows Vista - 32-Bit
//Scilab - 5.5.2


// Aim : A SCILAB program for conversion of symmetrical components into AC phasors


// To find Symmetrical Components for 3-phase Unbalanced System


clc;
clear all;

Q=[3 310
   5 105
   4 12
        ]
i=sqrt(-1);
n=3; // Number of Phases
a=1.0*(cos((360/n)*%pi/180)+%i*sin((360/n)*%pi/180));
a2=a^2;
// Conversion from Polar to Cartesian Form of Matrix I
Ia=Q(1)*(cos(Q(4)*%pi/180)+%i*sin(Q(4)*%pi/180));
Ib=Q(2)*(cos(Q(5)*%pi/180)+%i*sin(Q(5)*%pi/180));
Ic=Q(3)*(cos(Q(6)*%pi/180)+%i*sin(Q(6)*%pi/180));
// Define symmetrical components transformation matrix 
A=  [1    1     1
     1    a2    a
     1    a     a2];
A012=inv(A)*[Ia;Ib;Ic];
// To check the results
Add0=A012(1)+A012(2)+A012(3); //This is Ia
Add1=A012(1)+a2*A012(2)+a*A012(3); //This is Ib
Add2=A012(1)+a*A012(2)+a2*A012(3); // This is Ic
// Symmetrical Components in Cartesian Form 
Symm3= [A012(1) A012(2) A012(3)
        A012(1) a2*A012(2) a*A012(3)
        A012(1) a*A012(2) a2*A012(3)];
// Symmetrical Components in Polar Form
// Sym3Abs=abs(Symm3)
[sym3abs,Sym3Angle]=polar(Symm3)
sym3angle= Sym3Angle*180/%pi
disp('[Magnitude,Angle]')
mprintf('\n')
for i=1:3
    for j=1:3
       mprintf('[%.3f,%.3f]    ',sym3abs(i,j),sym3angle(i,j))
    end
    mprintf('\n')
end

// End of the Program


//output:-
//
//[Magnitude,Angle]   
//
//[3.817,35.558]    [-0.276,-19.726]    [-0.276,13.835]    
//[-0.276,-19.726]    [3.817,60.635]    [-0.276,53.517]    
//[-0.276,13.835]    [-0.276,53.517]    [3.817,-84.773]   
//
